import { world, EntityEquippableComponent, EquipmentSlot, ItemStack, EntityInventoryComponent } from "@minecraft/server";

let cords = "";
let dim = "";

world.afterEvents.worldInitialize.subscribe(() => {
  const w = world.getDimension("overworld");
  w.runCommandAsync(`gamerule sendCommandFeedback false`);
  w.runCommandAsync(`gamerule showTags false`);
  
});
world.afterEvents.playerSpawn.subscribe(spawn => {
  const p = spawn.player;
  if (p.hasTag("dead")) {
    playerKey(p);
    p.removeTag("dead");
  }
});
world.afterEvents.entityDie.subscribe(dead => {
  const p = dead.deadEntity;
  if (!p.hasTag('dead')) {
    dim = p.dimension.id
    const location = {
      x: Math.floor(p.location.x),
      y: Math.floor(p.location.y),
      z: Math.floor(p.location.z)
    }
    const tumba = p.dimension.spawnEntity('new:tumba', location);
    tumba.nameTag = p.name;
    try {
      p.dimension.fillBlocks(location, location, 'new:invisible_block');
    } catch (error) { }
    p.sendMessage(`§cYou died in §bx: §6${Math.floor(p.location.x)} by: §6${Math.floor(p.location.y)} §bz: §6${Math.floor(p.location.z)} in ${dim}`);
    cords = `§6${Math.floor(p.location.x)} ${Math.floor(p.location.y)} ${Math.floor(p.location.z)}§r`;
    p.addTag("dead");
  }
}, { entityTypes: ['minecraft:player'] });
world.afterEvents.itemUse.subscribe((data) => {
  const p = data.source;
  const itemStack = data.itemStack;
  if (itemStack.typeId == "new:key") {
    const location = `${itemStack.getLore()[1].replace("§r§bCords: §6", "").split(",")}`;
    const dimensions = `${itemStack.getLore()[2].replace("§r§bDimension: §6", "").split(",")}`;
    const x = location.split(" ")[0];
    const y = location.split(" ")[1];
    const z = location.replace("§r", "").split(" ")[2];
    p.teleport({ x: parseFloat(x) + 0.5, y: parseFloat(y) + 1, z: parseFloat(z) + 0.5 }, { dimension: world.getDimension(dimensions) });
  }
});
world.afterEvents.entityHitEntity.subscribe(ev => {
  const hit = ev.hitEntity;
  const entity = ev.damagingEntity;
  const playerEquipment = entity.getComponent(EntityEquippableComponent.componentId);
  const hand = playerEquipment?.getEquipment(EquipmentSlot.Mainhand);
  if (hit.typeId === 'new:tumba' && entity.typeId === 'minecraft:player' && hand) {
    if (hand.typeId === 'new:key_multi') {
      entity.runCommandAsync(`clear @s new:key_multi 0 1`);
      hit.runCommandAsync("setblock ~~~ air")
      entityHitFunctions[0](hit);
    }
    else if (hit.nameTag === entity.name && hand.typeId === 'new:key') {
      entity.runCommandAsync(`clear @s new:key 0 1`);
      hit.runCommandAsync("setblock ~~~ air")
      entityHitFunctions[0](hit);
    }
    else if (hit.nameTag === entity.name && hand.typeId === 'new:key2') {
      entity.runCommandAsync('clear @s new:key2 0 1');
      hit.runCommandAsync("setblock ~~~ air")
      entityHitFunctions[0](hit);
    }
    else if (hit.nameTag !== entity.nameTag && hit.typeId === 'new:tumba') {
      if (hand.typeId === 'new:key2' || hand.typeId === 'new:key') {
        entity.sendMessage(`%action.players.warn ${hit.name}`)
      }
    }
  }
});
const entityHitFunctions = [
  function hitEvent(hit) {
    const effectTime = 20 * 999999
    hit.addEffect('invisibility', effectTime, { amplifier: 255, showParticles: false });
    hit.triggerEvent('new:entity_death');
  }
];

function playerKey(p) {
  try{
    let container = p.getComponent("inventory").container;
    let item = new ItemStack("new:key");
    item.setLore([
      `§r§bPlayer: ${p.name}`,
      `§r§bCords: ${cords}`,
      `§r§bDimension: §6${dim}`,
      ``,
      `§r§cThis item is not lost when you die.§r`,
      ]);
    item.keepOnDeath = true;
    container.addItem(item);
  }
  catch(e){

  }
}